document.getElementById('analyzeBtn').addEventListener('click', async () => {
  const keyphrase = document.getElementById('keyphrase').value.trim();
  const resultsDiv = document.getElementById('results');
  const dashboard = document.getElementById('score-dashboard');

  if (!keyphrase) {
    resultsDiv.innerHTML = '<p style="color:#d63031; text-align:center;">Please enter a focus keyphrase.</p>';
    return;
  }

  resultsDiv.innerHTML = '<p style="text-align:center; color:#636e72;">Scanning page...</p>';
  dashboard.classList.add('hidden');

  const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });

  chrome.scripting.executeScript({
    target: { tabId: tab.id },
    files: ['content.js']
  }, () => {
    chrome.tabs.sendMessage(tab.id, { action: "analyze", keyphrase: keyphrase }, (response) => {
      if (chrome.runtime.lastError || !response) {
        resultsDiv.innerHTML = '<p style="text-align:center;">Error: Could not scan page. Refresh and try again.</p>';
      } else {
        renderResults(response);
      }
    });
  });
});

function renderResults(data) {
  const resultsDiv = document.getElementById('results');
  const dashboard = document.getElementById('score-dashboard');
  const scoreText = document.getElementById('score-text');
  const scoreStroke = document.getElementById('score-stroke');
  const scoreCircleDiv = document.querySelector('.score-circle');

  resultsDiv.innerHTML = '';
  dashboard.classList.remove('hidden');

  let passedCount = 0;

  data.forEach(item => {
    if (item.passed) passedCount++;

    const div = document.createElement('div');
    const statusClass = item.passed ? 'success' : (item.isCritical ? 'error' : 'warning');
    const icon = item.passed ? '✅' : (item.isCritical ? '❌' : '⚠️');

    div.className = `result-card ${statusClass}`;
    div.innerHTML = `
      <div class="icon">${icon}</div>
      <div class="content">${item.message}</div>
    `;
    resultsDiv.appendChild(div);
  });

  // Calculate Score
  const totalTests = data.length;
  const score = Math.round((passedCount / totalTests) * 100);

  // Update Score UI
  scoreText.textContent = score;
  
  // Update Color based on score
  scoreCircleDiv.classList.remove('score-high', 'score-med', 'score-low');
  if(score >= 80) scoreCircleDiv.classList.add('score-high');
  else if(score >= 50) scoreCircleDiv.classList.add('score-med');
  else scoreCircleDiv.classList.add('score-low');

  // Animate Circle
  // Stroke Dasharray: [filled, empty]. 100 is roughly full circle in this viewBox setup
  setTimeout(() => {
    scoreStroke.setAttribute('stroke-dasharray', `${score}, 100`);
  }, 100);
}